/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.cim.provider.rs6k.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.common.util.HscCecLock;
import com.ibm.hsc.common.util.HscCfgStatus;
import com.ibm.hsc.common.util.HscLockManager;
import com.ibm.hsc.common.util.HscPerformance;
import com.ibm.hsc.common.util.HscPrintStream;
import com.ibm.hsc.common.util.ProviderLceCommunication;
import com.ibm.hsc.rep.RCimWrapper;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RUtils;
import com.ibm.hsc.rep.v40.R40Test;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbem.provider.InstanceProvider;
import org.snia.wbem.provider.MethodProvider;
import org.snia.wbemcfg.GlobalConfig;

public class HSCSignalHandler
implements MethodProvider {
    public static final int SUCCESSFUL = 0;
    public static final int FAIL = -1;
    public static final HscCfgStatus cfgStatus = HscCfgStatus.getHscCfgStatus("/opt/hsc/data/cfgStatus");
    private ProviderCIMOMHandle mCIMOMHandle = null;
    private InstanceProvider mInstanceHandle = null;
    private static final int IO_BIT = 4;

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        System.out.println("********************");
        System.out.println("In initialize...");
        this.mCIMOMHandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.mInstanceHandle = this.mCIMOMHandle.getInternalProvider();
        System.out.println("End of initialize");
        System.out.println("********************");
    }

    public void cleanup() throws CIMException {
        System.out.println("********************");
        System.out.println("In cleanup ... ");
        this.mInstanceHandle.cleanup();
        this.mInstanceHandle = null;
        this.mCIMOMHandle = null;
        System.out.println("End of cleanup");
        System.out.println("********************");
    }

    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        UnsignedInt8 unsignedInt8;
        System.out.println("method name: " + string);
        if (string.equals("sendSignal")) {
            CIMValue cIMValue;
            if (GlobalConfig.callMethodsWithValues) {
                unsignedInt8 = (CIMValue)vector.elementAt(0);
                cIMValue = (CIMValue)vector.elementAt(1);
            } else {
                unsignedInt8 = ((CIMProperty)vector.elementAt(0)).getValue();
                cIMValue = ((CIMProperty)vector.elementAt(1)).getValue();
            }
            short s = ((UnsignedInt8)unsignedInt8.getValue()).shortValue();
            System.out.println("signal type: " + s);
            Vector vector3 = (Vector)cIMValue.getValue();
            HscPrintStream hscPrintStream = null;
            switch (s) {
                case 1: {
                    hscPrintStream = HscPrintStream.getInstance();
                    if (hscPrintStream == null) break;
                    hscPrintStream.setTraceOn(null);
                    System.setOut(hscPrintStream);
                    System.setErr(hscPrintStream);
                    cfgStatus.setProperty("cimServerLog", "on");
                    break;
                }
                case 2: {
                    hscPrintStream = HscPrintStream.getInstance();
                    if (hscPrintStream != null) {
                        hscPrintStream.setTraceOff();
                    }
                    cfgStatus.setProperty("cimServerLog", "off");
                    break;
                }
                case 3: {
                    HSCEventIndicationMgr hSCEventIndicationMgr = HSCEventIndicationMgr.getInstance();
                    if (hSCEventIndicationMgr == null) break;
                    hSCEventIndicationMgr.printStatus();
                    break;
                }
                case 4: {
                    HscPerformance.enable();
                    break;
                }
                case 5: {
                    HscPerformance.disable();
                    break;
                }
                case 6: {
                    String string2 = (String)vector3.elementAt(0);
                    HscProviderUtils.setAppTimeoutValue(Integer.parseInt(string2));
                    break;
                }
                case 7: {
                    System.out.println("start of dumpLockInfo");
                    ProviderLceCommunication.dump();
                    HscLockManager.GetHscProviderLockManager().dump();
                    CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
                    CIMClass cIMClass = this.mCIMOMHandle.getClass(cIMObjectPath2, false);
                    Vector vector4 = RCimWrapper.enumInstances((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath2, 4);
                    if (vector4 != null) {
                        int n = 0;
                        while (n < vector4.size()) {
                            CIMInstance cIMInstance = (CIMInstance)vector4.elementAt(n);
                            String string3 = (String)cIMInstance.getProperty("Name").getValue().getValue();
                            HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
                            HscCecLock hscCecLock = hscLockManager.getHscCecLock(string3);
                            System.out.println("lock queue for cec: " + string3);
                            hscCecLock.print();
                            ++n;
                        }
                    }
                    System.out.println("end of dumpLockInfo");
                    break;
                }
                case 8: {
                    System.out.println("got signal 8 ");
                    String string4 = (String)vector3.elementAt(0);
                    String string5 = (String)vector3.elementAt(1);
                    System.out.println("valStr" + string5);
                    String string6 = (String)vector3.elementAt(2);
                    this.setDlparCapability(string4, string5, string6);
                    break;
                }
                case 200: {
                    String string7 = (String)vector3.elementAt(0);
                    PrintWriter printWriter = null;
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream("/var/hsc/log/hmcdump.dat");
                        printWriter = new PrintWriter(fileOutputStream);
                        long l = System.currentTimeMillis();
                        Timestamp timestamp = new Timestamp(l);
                        printWriter.println(timestamp + ": dump repository for name space " + string7);
                        printWriter.println();
                        RUtils.dumpAllObjs(string7, printWriter);
                        RUtils.dumpAllAssos(string7, printWriter);
                        printWriter.println("===== end of dump =====");
                        printWriter.close();
                        break;
                    }
                    catch (RException rException) {
                        if (printWriter != null) {
                            printWriter.close();
                        }
                        rException.printStackTrace();
                        throw new CIMException(rException.getID());
                    }
                    catch (Throwable throwable) {
                        if (printWriter != null) {
                            printWriter.close();
                        }
                        throwable.printStackTrace();
                        throw new CIMException(throwable.getMessage());
                    }
                }
                case 201: {
                    try {
                        R40Test.runTest((CIMOMHandle)this.mCIMOMHandle);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    break;
                }
            }
        }
        unsignedInt8 = new UnsignedInt8(0);
        return new CIMValue((Object)unsignedInt8, new CIMDataType(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDlparCapability(String string, String string2, String string3) throws CIMException {
        String string4 = string.substring(4);
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string4);
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMObjectPath.addKey("Name", new CIMValue((Object)string));
            CIMClass cIMClass = this.mCIMOMHandle.getClass(cIMObjectPath, false);
            hscCecLock.Lock(1);
            CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMClass, false);
            CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
            boolean bl = false;
            int n = Integer.parseInt(string2);
            System.out.println("val: " + n);
            int n2 = ((UnsignedInt8)cIMInstance2.getProperty("PartitionType").getValue().getValue()).intValue();
            if (n2 == 2 || n2 == 3) {
                System.out.println("alpar only set IO bit");
                n &= 4;
            }
            if (CimomWrapper.setProperty(cIMInstance2, "DLPARCapabilities", new UnsignedInt32((long)n))) {
                bl = true;
            }
            if (CimomWrapper.setProperty(cIMInstance2, "SysCmdCapabilities", new UnsignedInt32(string3))) {
                bl = true;
            }
            CimomWrapper.setInstance((CIMOMHandle)this.mCIMOMHandle, cIMObjectPath, cIMInstance2);
            if (bl) {
                System.out.println("sending out indication for dlpar cap change");
                AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
            }
            Object var15_14 = null;
            System.out.println("release cec lock for " + string4);
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            System.out.println("release cec lock for " + string4);
            try {
                hscCecLock.Unlock();
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            throw throwable;
        }
        try {
            hscCecLock.Unlock();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

